#include "sharerecorddlg.h"
#include "ui_sharerecorddlg.h"
#include "mainwindow.h"

ShareRecordDlg::ShareRecordDlg(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::ShareRecordDlg)
{ 
    ui->setupUi(this);

    this->setFixedSize(930, 320);

    this->setWindowTitle("SHARE RECORD DIALOG");

    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    ui->BTN_StartShareRecord->setEnabled(true);

    ui->BTN_StopShareRecord->setEnabled(false);

    ui->checkBox_SR_GPU->setEnabled(false);

    ui->checkBox_SR_MP4->setChecked(true);

    ui->checkBox_SR_AVI->setChecked(false);

    ui->radioButton_CH1->setChecked(true);

    ui->lineEdit_SR_Path->setText( SC540dlg->path + QString("/ShareRecord.mp4"));    
}

ShareRecordDlg::~ShareRecordDlg()
{
    on_BTN_StopShareRecord_clicked();

    delete ui;
}

void ShareRecordDlg::on_BTN_StartShareRecord_clicked()
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    if ( ui->radioButton_CH1->isChecked() ) { m_nChannelIndex = 0; };

    if ( ui->radioButton_CH2->isChecked() ) { m_nChannelIndex = 1; };

    if ( ui->radioButton_CH3->isChecked() ) { m_nChannelIndex = 2; };

    if ( ui->radioButton_CH4->isChecked() ) { m_nChannelIndex = 3; };

    if( ui->checkBox_SR_GPU->isChecked() ) {

        QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY( 0, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYPE_YV12, SC540dlg->m_nVideoWidth[ m_nChannelIndex ], SC540dlg->m_nVideoHeight[ m_nChannelIndex ],
                                              30, QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, (HWND)ui->m_DisplayWindow->winId(), true );

    } else {

        QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY( 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYPE_YV12, SC540dlg->m_nVideoWidth[ m_nChannelIndex ], SC540dlg->m_nVideoHeight[ m_nChannelIndex ],
                                              30, QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, (HWND)ui->m_DisplayWindow->winId(), true );
    }

    if( ui->checkBox_SR_MP4->isChecked())
    {
        QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY( 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC, SC540dlg->m_nAudioChannels[ m_nChannelIndex ], SC540dlg->m_nAudioBitsPerSample[ m_nChannelIndex ], SC540dlg->m_nAudioSampleFrequency[ m_nChannelIndex ] );

    } else {

        QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY( 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_PCM, SC540dlg->m_nAudioChannels[ m_nChannelIndex ], SC540dlg->m_nAudioBitsPerSample[ m_nChannelIndex ], SC540dlg->m_nAudioSampleFrequency[ m_nChannelIndex ] );
    }

    QCAP_START_SHARE_RECORD( 0, ui->lineEdit_SR_Path->text().toLatin1().data(), QCAP_RECORD_FLAG_DISPLAY );

    SC540dlg->m_bIsShareRecord = true;

    SC540dlg->m_nShareRecordCH = m_nChannelIndex;

    ui->BTN_StartShareRecord->setEnabled(false);

    ui->BTN_StopShareRecord->setEnabled(true);
}

void ShareRecordDlg::on_BTN_StopShareRecord_clicked()
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    if ( SC540dlg->m_bIsShareRecord == true ) {

        QCAP_STOP_SHARE_RECORD( 0 );
    }    

    SC540dlg->m_bIsShareRecord = false;

    ui->BTN_StartShareRecord->setEnabled(true);

    ui->BTN_StopShareRecord->setEnabled(false);

}

void ShareRecordDlg::on_checkBox_SR_AVI_stateChanged(int arg1)
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    if( arg1 == 0 ) {

        ui->checkBox_SR_MP4->setChecked(true);

        ui->lineEdit_SR_Path->setText(SC540dlg->path + QString("/ShareRecord.mp4"));

    } else {

        ui->checkBox_SR_MP4->setChecked(false);

        ui->lineEdit_SR_Path->setText(SC540dlg->path + QString("/ShareRecord.avi"));
    }
}

void ShareRecordDlg::on_checkBox_SR_MP4_stateChanged(int arg1)
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    if( arg1 == 0 ) {

        ui->checkBox_SR_AVI->setChecked(true);

        ui->lineEdit_SR_Path->setText(SC540dlg->path + QString("/ShareRecord.avi"));

    } else {

        ui->checkBox_SR_AVI->setChecked(false);

        QString psz = SC540dlg->path + QString("/ShareRecord.mp4");

        ui->lineEdit_SR_Path->setText(psz);
    }
}

void ShareRecordDlg::on_radioButton_CH1_clicked()
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    SC540dlg->m_nShareRecordCH = 0;
}

void ShareRecordDlg::on_radioButton_CH2_clicked()
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    SC540dlg->m_nShareRecordCH = 1;
}

void ShareRecordDlg::on_radioButton_CH3_clicked()
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    SC540dlg->m_nShareRecordCH = 2;
}

void ShareRecordDlg::on_radioButton_CH4_clicked()
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    SC540dlg->m_nShareRecordCH = 3;
}

void ShareRecordDlg::on_radioButton_CH5_clicked()
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    SC540dlg->m_nShareRecordCH = 4;
}

void ShareRecordDlg::on_radioButton_CH6_clicked()
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    SC540dlg->m_nShareRecordCH = 5;
}

void ShareRecordDlg::on_radioButton_CH7_clicked()
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    SC540dlg->m_nShareRecordCH = 6;
}

void ShareRecordDlg::on_radioButton_CH8_clicked()
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    SC540dlg->m_nShareRecordCH = 7;
}
